;*
;* JAVA CLASS CLASS FOR 6502
;*
	.INCLUDE	"global.inc"
	.INCLUDE	"class.inc"
	.IMPORT	HMEM_LOCK,HMEM_UNLOCK
	.IMPORT	HMEM_PTR,HMEM_REF_INC,HMEM_REF_DEC
	.IMPORT	HSTR_HASH,STR_HASH,HSTRPL_ADD,HSTRPL_DEL
	.IMPORT	MEMSRC,MEMDST,MEMCLR,MEMCPY
	.IMPORT	LOADCLASS_FILE
	.IMPORT	THROW_INTERNALERR
	.EXPORT	HCLASS_INIT,HCLASS_NAME,HCLASS_HNDL,HCLASS_INDEX,HCLASS_ADD
	.EXPORT	CLASS_STRING,CLASS_MATCH_NAME,CLASS_MATCH_DESC,CLASS_CONSTPTR,CLASS_VIRTCODE
	.EXPORT	RESOLVE_CLASS,RESOLVE_METHOD,CLASS_METHODPTR,RESOLVE_FIELD,CLASS_FIELDPTR
	.EXPORT	CLASS_LOCKMETHOD,CLASS_UNLOCKMETHOD,CLASS_OF

	.SEGMENT "INIT"
;*
;* CLEAR CLASS TABLE
;*
HCLASS_INIT:	LDA	#<HCLASS_TBLL
	LDX	#>HCLASS_TBLL
	JSR	MEMDST
	LDA	#$00
	LDX	#$01
	JSR	MEMCLR
	RTS

	.DATA
;HCLASS_TBLL:	.RES	128, $00
;HCLASS_TBLH:	.RES	128, $00

	.CODE
;*
;* THE CLASS TABLE MATCHES NAMES TO CLASSES
;*	
;* FIND A CLASS GIVEN IT'S NAME
;* ENTRY: AX = HSTRNAME
;* EXIT:  AX = HCLASS
;*         Y = INDEX
;*         C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
HCLASS_NAME:	STA	HSTR
	STX	HSTR+1
	LDY	#$01
FINDSTRLP:	LDX	HCLASS_TBLH,Y
	BEQ	FINDSTRNXT		; SKIP NULL HANDLES
	LDA	HCLASS_TBLL,Y
	STY	CCLASSCNT
	JSR	HMEM_PTR		; CONVERT TO ADDRESS
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSTHIS
	LDA	(CCLASSPTR),Y
	CMP	HSTR
	BNE	:+
	INY
	LDA	(CCLASSPTR),Y
	CMP	HSTR+1
	BNE	:+
	LDY	CCLASSCNT		; FOUND IT
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	CLC			; RETURN SUCCESS
	RTS
:	LDY	CCLASSCNT
FINDSTRNXT:	INY
	BPL	FINDSTRLP		; KEEP CHECKING
	SEC			; NOT FOUND
	RTS			; RETURN FAIL
;*
;* FIND A CLASS GIVEN IT'S HANDLE
;* ENTRY: AX = HCLASS
;* EXIT:  AX = HCLASS
;*         Y = INDEX
;*         C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
HCLASS_HNDL:	LDY	#$01
FINDCLSLP:	CMP	HCLASS_TBLL,Y
	BNE	FINDCLSNXT		; SEARCH FOR A MATCH
	PHA
	TXA
	CMP	HCLASS_TBLH,Y
	BNE	:+
	PLA			; FOUND IT
	CLC			; RETURN SUCCESS
	RTS
:	PLA
FINDCLSNXT:	INY
	BPL	FINDCLSLP		; KEEP CHECKING
	SEC			; NOT FOUND
	RTS			; RETURN FAIL
;*
;* RETURN A CLASS HANDLE GIVEN ITS INDEX
;* ENTRY:  Y = INDEX
;* EXIT:  AX = HANDLE
;*         Y = INDEX
;*
HCLASS_INDEX:	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	RTS
;*
;* RETURN A CLASS NAME STRING GIVEN ITS INDEX
;* ENTRY: Y = INDEX
;* EXIT: AX = HSTR
;*
CLASS_STRING:	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCINST
	STX	CCINST+1	
	LDY	#CLASSTHIS+1
	LDA	(CCINST),Y
	DEY
	TAX
	LDA	(CCINST),Y
	RTS
;*
;* ADD A NEW CLASS GIVEN IT'S HANDLE
;* ENTRY: AX = CLASS HANDLE
;* EXIT:  AX = CLASS HANDLE
;*         Y = INDEX
;*         C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
HCLASS_ADD:	JSR	HCLASS_HNDL
	BCS	:+
	PERR	"ADD CLASS ALREADY PRESENT"
	RTS
:	PHA
.IFDEF	DEBUG
	STA	CCINST
	STX	CCINST+1
	JSR	HMEM_PTR
	STA	HSTR
	STX	HSTR+1
	LDY	#CLASSTHIS+1
	LDA	(HSTR),Y
	DEY
	TAX
	LDA	(HSTR),Y
	JSR	HCLASS_NAME
	BCS	:+
	PERR	"EXISTING CLASS IN TABLE"
	JMP	THROW_INTERNALERR
:	LDA	CCINST
	LDX	CCINST+1
.ENDIF
	LDY	#$01
HCLASSADDLP:	LDA	HCLASS_TBLH,Y
	BEQ	HCLASSADDIT
	INY
	BPL	HCLASSADDLP
	PERR	"FULL CLASS TABLE"
	SEC
	RTS
HCLASSADDIT:	PLA
	STA	HCLASS_TBLL,Y
	PHA
	TXA
	STA	HCLASS_TBLH,Y
	PLA
	CLC
	RTS
.IF	0
;*
;* DELETE A CLASS
;* ENTRY: AX = HANDLE
;* EXIT:   C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
HCLASS_DEL:	JSR	HCLASS_HNDL
	BCS	:+
HCLASS_IDEL:	LDA	#$00
	STA	HCLASS_TBLL,Y
	STA	HCLASS_TBLH,Y
:	RTS
.ENDIF
;*
;* SET HNAMESTR USED IN IFACE/FIELD/METHOD LOOKUPS
;* ENTRY: AX = HNAMESTR
;*
CLASS_MATCH_NAME: STA	CCLASSNAME
	STX	CCLASSNAME+1
	RTS
;*
;* SET HDESCSTR USED IN IFACE/FIELD/METHOD LOOKUPS
;* ENTRY: AX = HNDESCSTR
;*
CLASS_MATCH_DESC: STA	CCLASSDESC
	STX	CCLASSDESC+1
	RTS
;*
;* FIND CLASS GIVEN ITS NAME, LOAD IT IF NECESSARY
;* ENTRY: AX = HNAMESTR
;* EXIT:  AX = CLASS HANDLE
;*         Y = CLASS INDEX
;*         C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
RESOLVE_CLASS:	JSR	HCLASS_NAME		; LOOKUP CLASS IN TABLE
	BCS	:+
	RTS
:	LDA	HSTR		; NOT FOUND, LOAD CLASS FROM FILE
	LDX	HSTR+1
	JMP	LOADCLASS_FILE		; LOAD CLASS AND SUPERCLASSES
;*
;* FIND A METHOD GIVEN CLASS INDEX AND DESCRIPTION
;* ENTRY:  Y = CLASS INDEX
;* EXIT:  AX = METHOD OFFSET
;*         Y = CLASS INDEX (COULD BE SUPERCLASS)
;*         C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
RESOLVE_METHOD: STY	CCLASSINDEX
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSMETHODTBL+1
	LDA	(CCLASSPTR),Y
	BEQ	RESLVSUPRMETHD		; NO METHODS DEFINED FOR THIS CLASS, CHECK SUPER
	DEY
	TAX
	LDA	(CCLASSPTR),Y
	JSR	HMEM_PTR
	STA	CCTBLPTR
	STA	TMP
	STX	CCTBLPTR+1
	STX	TMP+1
	LDY	#CLASSMETHODCNT
	LDA	(CCLASSPTR),Y
	TAX
FINDMETHODLP:	LDY	#METHODNAME
	LDA	(CCTBLPTR),Y
	CMP	CCLASSNAME
	BNE	NEXTMETHOD
	INY
	LDA	(CCTBLPTR),Y
	CMP	CCLASSNAME+1
	BNE	NEXTMETHOD
	INY
	LDA	(CCTBLPTR),Y
	CMP	CCLASSDESC
	BNE	NEXTMETHOD
	INY
	LDA	(CCTBLPTR),Y
	CMP	CCLASSDESC+1
	BNE	NEXTMETHOD
	LDA	CCTBLPTR		; FOUND MATCH
	SEC			; CALC OFFSET INTO TABLE
	SBC	TMP
	TAY
	LDA	CCTBLPTR+1
	SBC	TMP+1
	TAX
	TYA
	LDY	CCLASSINDEX
	CLC
	RTS
NEXTMETHOD:	LDA	CCTBLPTR
	CLC
	ADC	#METHODRECSZ
	STA	CCTBLPTR
	BCC	:+
	INC	CCTBLPTR+1
:	DEX
	BNE	FINDMETHODLP
RESLVSUPRMETHD:	LDY	#CLASSSUPER		; SEARCH SUPERCLASS
	LDA	(CCLASSPTR),Y
	TAY
	BNE	RESOLVE_METHOD
	SEC			; OUT OF SUPERCLASSES
	RTS
;*
;* RETURN POINTER TO METHOD GIVEN INDECES
;* ENTRY: AX = METHOD OFFSET
;*         Y = CLASS INDEX
;* EXIT:  AX = METHOD POINTER
;*
CLASS_METHODPTR: STA	CCTBLPTR
	STX	CCTBLPTR+1
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSMETHODTBL+1
	LDA	(CCLASSPTR),Y
	DEY
	TAX
	LDA	(CCLASSPTR),Y
	JSR	HMEM_PTR
	CLC
	ADC	CCTBLPTR
	PHA
	TXA
	ADC	CCTBLPTR+1
	TAX
	PLA
	RTS
;*
;* LOCK CLASS METHOD AND RETURN POINTER
;* JUST LIKE CLASS_METHODPTR, BUT LOCK MEMORY
;* ENTRY: AX = METHOD OFFSET
;*         Y = CLASS INDEX
;* EXIT:  AX = METHOD POINTER
;*
CLASS_LOCKMETHOD: STA	CCTBLPTR
	STX	CCTBLPTR+1
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSMETHODTBL+1
	LDA	(CCLASSPTR),Y
	DEY
	TAX
	LDA	(CCLASSPTR),Y
	JSR	HMEM_LOCK
	CLC
	ADC	CCTBLPTR
	PHA
	TXA
	ADC	CCTBLPTR+1
	TAX
	PLA
	RTS
;*
;* UNLOCK METHOD, CALL AFTER DONE WITH ABOVE
;* ENTRY: Y = CLASSINDEX
;*
CLASS_UNLOCKMETHOD: LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSMETHODTBL+1
	LDA	(CCLASSPTR),Y
	DEY
	TAX
	LDA	(CCLASSPTR),Y
	JMP	HMEM_UNLOCK
;*
;* FIND A FIELD GIVEN CLASS INDEX AND DESCRIPTION
;* ENTRY:  Y = CLASS INDEX
;* EXIT:  AX = FIELD OFFSET
;*         Y = CLASS INDEX (COULD BE SUPERCLASS)
;*         C = 0 :: SUCCESS
;*         C = 1 :: FAILURE
;*
RESOLVE_FIELD:	STY	CCLASSINDEX
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSFIELDTBL+1
	LDA	(CCLASSPTR),Y
	BEQ	RESLVSUPRFIELD		; NO FIELDS FOR THIS CLASS, CHECK SUPER
	DEY
	TAX
	LDA	(CCLASSPTR),Y
	JSR	HMEM_PTR
	STA	CCTBLPTR
	STA	TMP
	STX	CCTBLPTR+1
	STX	TMP+1
	LDY	#CLASSFIELDCNT
	LDA	(CCLASSPTR),Y
	TAX
FINDFIELDLP:	LDY	#FIELDNAME
	LDA	(CCTBLPTR),Y
	CMP	CCLASSNAME
	BNE	NEXTFIELD
	INY
	LDA	(CCTBLPTR),Y
	CMP	CCLASSNAME+1
	BNE	NEXTFIELD
	INY
	LDA	(CCTBLPTR),Y
	CMP	CCLASSDESC
	BNE	NEXTFIELD
	INY
	LDA	(CCTBLPTR),Y
	CMP	CCLASSDESC+1
	BNE	NEXTFIELD
	LDA	CCTBLPTR		; FOUND MATCH
	SEC			; CALC OFFSET INTO TABLE
	SBC	TMP
	TAY
	LDA	CCTBLPTR+1
	SBC	TMP+1
	TAX
	TYA
	LDY	CCLASSINDEX
	CLC
	RTS
NEXTFIELD:	LDA	CCTBLPTR
	CLC
	ADC	#FIELDRECSZ
	STA	CCTBLPTR
	BCC	:+
	INC	CCTBLPTR+1
:	DEX
	BNE	FINDFIELDLP
RESLVSUPRFIELD:	LDY	#CLASSSUPER		; SEARCH SUPERCLASS
	LDA	(CCLASSPTR),Y
	TAY
	BNE	RESOLVE_FIELD
	SEC			; OUT OF SUPERCLASSES
	RTS
;*
;* RETURN POINTER TO FIELD GIVEN INDECES
;* ENTRY: AX = FIELD OFFSET
;*         Y = CLASS INDEX
;* EXIT:  AX = FIELD POINTER
;*
CLASS_FIELDPTR:	STA	CCTBLPTR
	STX	CCTBLPTR+1
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSFIELDTBL+1
	LDA	(CCLASSPTR),Y
	DEY
	TAX
	LDA	(CCLASSPTR),Y
	JSR	HMEM_PTR
	CLC
	ADC	CCTBLPTR
	PHA
	TXA
	ADC	CCTBLPTR+1
	TAX
	PLA
	RTS
;*
;* RETURN CODE HANDLE FROM VIRTUAL METHOD TABLE
;* ENTRY: AX = VIRTUAL TABLE OFFSET
;*         Y = CLASS INDEX
;* EXIT:  AX = CODE HANDLE
;*     
CLASS_VIRTCODE:	 STA	CCTBLPTR
	STX	CCTBLPTR+1
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSVIRTBL+1
	LDA	(CCLASSPTR),Y
	DEY
	TAX
	LDA	(CCLASSPTR),Y
	JSR	HMEM_PTR
	CLC
	ADC	CCTBLPTR
	STA	CCTBLPTR
	TXA
	ADC	CCTBLPTR+1
	STA	CCTBLPTR+1
	LDY	#$01
	LDA	(CCTBLPTR),Y
	DEY
	TAX
	LDA	(CCTBLPTR),Y
	RTS
;*
;* RETURN POINTER TO CONSTANT POOL GIVEN CLASS AND INDEX
;* ENTRY: AX = CONSTANT INDEX
;*         Y = CLASS INDEX
;* EXIT:  AX = CONSTANT POINTER
;*
CLASS_CONSTPTR: CALC_CONSTPLRECSZ
	CLC
	ADC	#(CLASSCONSTPL-CONSTPLRECSZ)	; INDEX IS 1 BASED
	BCC :+
	INX
:	STA	CCTBLPTR
	STX	CCTBLPTR+1
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	CLC
	ADC	CCTBLPTR
	TAY
	TXA
	ADC	CCTBLPTR+1
	TAX
	TYA
	RTS
;*
;* DETERMINE IF A CLASS IS A SUBCLASS OF ANOTHER
;* !!! NEEDS TO CHECK INTERFACES AND ARRAYS !!!
;* ENTRY: A = SUB CLASS
;*        Y = SUPER CLASS
;* EXIT: C = 0 :: A IS SUBCLASS OF Y
;*       C = 1 :: A IS NOT SUBCLASS OF Y
;*
CLASS_OF:	STY	CCLASSINDEX
CLASSOFCHK:	CMP	CCLASSINDEX
	BNE	:+
	CLC
	RTS
:	TAY
	LDX	HCLASS_TBLH,Y
	LDA	HCLASS_TBLL,Y
	JSR	HMEM_PTR
	STA	CCLASSPTR
	STX	CCLASSPTR+1
	LDY	#CLASSSUPER
	LDA	(CCLASSPTR),Y
	BNE	CLASSOFCHK
	SEC
	RTS
